
// BIPaymentMethodType.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.

/*!
    @class       BIPaymentMethodType
    @abstract    BIPaymentMethodType represents a type of payment, ie. Cash, Visa, Cheque, etc.
    @discussion  Use retainer, is a special retainer type which means that we will be taking the money from the retainer (ie. money we already have) rather than receiving money we did not have from the client.  This just differentiates the logic when the payment is applied, ie. should we be taking it out of the retainer
*/


#ifdef BILLINGS_PRO
#import "_BPPaymentMethodType.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIPaymentMethodType.h"
#endif
#import "BIAppVersioning.h"


@interface BIPaymentMethodType : BL_SUPER_CLASSNAME_MUNGE(PaymentMethodType) 
{
}

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;

- (BOOL)useRetainerBool;
- (void)setUseRetainerBool:(BOOL)aFlag;

@end
